/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 /page/box_gamma页面函数(箱体)
*
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.05.21
*      内容 : 所有代码
************************************************************************************************/

/* exported tc_init_box_gamma */
/* exported tc_record_box_gamma */
/* exported tc_tab_box_gamma */

/* global $ */
/* global mc_sdk_param */


// 页面层级
// 顶层
var obj_box_gamma_iframe_top = "";
// main层
var obj_box_gamma_iframe_sub_main = "";
// 子页面层
var obj_box_gamma_iframe_child_page = "";
// 子页面dom层
var obj_box_gamma_html_child_page = "";
// 子页面方面变量定义层
var obj_box_gamma_window_child_page = "";

// 比较数据结果
var arr_jungle_result = [];

// 时间
var box_gamma_time = 1000;
var ui_time_into_boxmain = 1000;

// tab dom 用于测试用例1
var arr_tab_dom = [];
// tab name 用于测试用例1
var arr_tab_jungle_name = [];
var arr_tab_page_name = [];

// 界面存储数据 用于测试用例2
var obj_box_gamma_init = {
    "chart_type_name": "",
    "appoint_type_name": "",
    "type": "",
    "data": "",
    "gray_bit": "",
    "y_val": "",
    "factor": "",
    "mode_val_idx": "",
    "box_default_max_val": "",
    "curr_ctrl_chip": "",
    "curr_disp_chip": ""
};

// 界面数据 / 比较数据
var obj_box_gamma_page_data = {};
var obj_box_gamma_jungle_data = {};

//用于存储界面数据 帮助obj_box_gamma_page_data
var obj_page = {};

/* -------------------------------------------------------------------测试用例函数----------------------------------------------------------------- */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试初始化渲染界面 ( 显示芯片顺序: ICN2053,GENERAL,SM16159S )
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-21
 *       内容 : 所有代码
************************************************************************************************/
function tc_init_box_gamma(callback) {
    mc_box_gamma_clear_iframe_page();
    mc_box_gamma_test_box_exist(function () {
        mc_box_gamma_open_side_page("mc_side_btn_mod_wizard", function () {
            $(obj_box_gamma_iframe_sub_main).contents().find("#mc_side_btn_add").click();
            setTimeout(() => {
                mc_box_gamma_get_child_page("", "iframe_content_subpage");
                mc_box_gamma_set_chip(1, 6, 4, function (b_go) {
                    if (!b_go) {
                        callback("0", "界面打开超时,请等待box_main界面加载后重新执行此用例");
                        return;
                    }

                    mc_box_gamma_get_child_page(0, "layui-layer-iframe");
                    // ICN2053 3个界面 箱体默认表
                    arr_tab_jungle_name = ["MC_LANG_BTN_GAM_BOX_DEFAULT_TBL", "MC_LANG_BTN_GAM_CALCULATE_TBL", "MC_LANG_BTN_GAM_CUSTOMIZATION_TBL"];

                    arr_tab_dom = obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].getElementsByTagName("span");
                    arr_tab_page_name = [];
                    for (var id_ICN = 0; id_ICN < arr_tab_dom.length; id_ICN++) {
                        arr_tab_page_name.push(arr_tab_dom[id_ICN].getAttribute("lang_id"));
                    }

                    arr_jungle_result = mc_box_gamma_jungle_tab(arr_tab_jungle_name, arr_tab_page_name);
                    if (!arr_jungle_result[0]) {
                        callback("0", arr_jungle_result[1]);
                        return;
                    }

                    // 删除界面
                    obj_box_gamma_iframe_child_page[0].getElementsByClassName("layui-layer-close")[0].click();
                    mc_box_gamma_get_child_page(0, "iframe_content_subpage");

                    setTimeout(() => {
                        obj_box_gamma_html_child_page.getElementById("mc_btn_mod_modify").onclick();
                        setTimeout(() => {
                            mc_box_gamma_get_child_page("", "iframe_content_subpage");
                            mc_box_gamma_set_chip(0, 4, 1, function (b_go_sec) {
                                if (!b_go_sec) {
                                    callback("0", "界面打开超时,请等待box_main界面加载后重新执行此用例");
                                    return;
                                }
                                mc_box_gamma_get_child_page(0, "layui-layer-iframe");
                                // GENERAL 2个界面
                                arr_tab_jungle_name = ["MC_LANG_BTN_GAM_CALCULATE_TBL", "MC_LANG_BTN_GAM_CUSTOMIZATION_TBL"];
                                arr_tab_dom = obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].getElementsByTagName("span");
                                arr_tab_page_name = [];
                                for (var id_GN = 0; id_GN < arr_tab_dom.length; id_GN++) {
                                    arr_tab_page_name.push(arr_tab_dom[id_GN].getAttribute("lang_id"));
                                }
                                arr_jungle_result = mc_box_gamma_jungle_tab(arr_tab_jungle_name, arr_tab_page_name);
                                if (!arr_jungle_result[0]) {
                                    callback("0", arr_jungle_result[1]);
                                    return;
                                }


                                // 删除界面
                                obj_box_gamma_iframe_child_page[0].getElementsByClassName("layui-layer-close")[0].click();
                                mc_box_gamma_get_child_page(0, "iframe_content_subpage");

                                setTimeout(() => {
                                    obj_box_gamma_html_child_page.getElementById("mc_btn_mod_modify").onclick();
                                    setTimeout(() => {
                                        mc_box_gamma_get_child_page("", "iframe_content_subpage");
                                        // 1, 10, 2
                                        mc_box_gamma_set_chip(2, 11, 6, function (b_go_third) {
                                            if (!b_go_third) {
                                                callback("0", "界面打开超时,请等待box_main界面加载后重新执行此用例");
                                                return;
                                            }
                                            mc_box_gamma_get_child_page(0, "layui-layer-iframe");
                                            // SM16159S 四个界面
                                            arr_tab_jungle_name = ["MC_LANG_BTN_GAM_BOX_DEFAULT_TBL", "MC_LANG_BTN_GAM_APPOINT_TBL", "MC_LANG_BTN_GAM_CALCULATE_TBL", "MC_LANG_BTN_GAM_CUSTOMIZATION_TBL"];
                                            arr_tab_dom = obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].getElementsByTagName("span");
                                            arr_tab_page_name = [];
                                            for (var id_SM = 0; id_SM < arr_tab_dom.length; id_SM++) {
                                                arr_tab_page_name.push(arr_tab_dom[id_SM].getAttribute("lang_id"));
                                            }
                                            arr_jungle_result = mc_box_gamma_jungle_tab(arr_tab_jungle_name, arr_tab_page_name);

                                            if (!arr_jungle_result[0]) {
                                                callback("0", arr_jungle_result[1]);
                                            } else {
                                                callback("1", "测试完成,数据显示正确");
                                            }
                                            return;
                                        });
                                    }, box_gamma_time);
                                }, box_gamma_time);
                            });
                        }, box_gamma_time);
                    }, box_gamma_time);
                });
            }, box_gamma_time);
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试界面记录功能 ( 例子:SM16159S )
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-22
 *       内容 : 所有代码
************************************************************************************************/
function tc_record_box_gamma(callback) {
    obj_box_gamma_page_data = JSON.parse(JSON.stringify(obj_box_gamma_init));
    // obj_box_gamma_jungle_data = JSON.parse(JSON.stringify(obj_box_gamma_init));
    obj_box_gamma_jungle_data = mc_get_default_data();
    mc_box_gamma_clear_iframe_page();
    mc_box_gamma_test_box_exist(function () {
        mc_box_gamma_open_side_page("mc_side_btn_mod_wizard", function () {
            $(obj_box_gamma_iframe_sub_main).contents().find("#mc_side_btn_add").click();
            setTimeout(() => {
                mc_box_gamma_get_child_page("", "iframe_content_subpage");
                // 1, 10, 2
                mc_box_gamma_set_chip(2, 11, 6, function (b_go) {
                    if (!b_go) {
                        callback("0", "界面打开超时,请等待box_main界面加载后重新执行此用例");
                        return;
                    }
                    mc_box_gamma_remove_page("dialog");
                    mc_box_gamma_get_child_page(0, "layui-layer-iframe");
                    obj_box_gamma_html_child_page.getElementsByClassName("mc_appoint_gamma_tbl")[0].children[0].children[3].onmousedown();

                    // 选中指定表D
                    setTimeout(() => {
                        // 选中tab栏计算表
                        obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].children[2].onclick();
                        setTimeout(() => {
                            // 灰阶数改为9
                            obj_box_gamma_html_child_page.getElementsByClassName("select_text")[0].onclick();
                            obj_box_gamma_html_child_page.getElementsByClassName("select_list")[0].children[1].onclick();
                            setTimeout(() => {
                                // 修改最大值 40000
                                var id_max_val = obj_box_gamma_window_child_page.gam_y_edit_right.get_id();

                                obj_box_gamma_html_child_page.getElementsByClassName("mc_y_axis_area_second_value")[0].value = "40000";
                                obj_box_gamma_window_child_page.onValchg(id_max_val, "40000");
                                setTimeout(() => {
                                    // 滑动条2.3
                                    obj_box_gamma_window_child_page.gam_slider.set_dom_val("2.3");
                                    var id_slider = obj_box_gamma_window_child_page.gam_slider.get_id();

                                    obj_box_gamma_window_child_page.onValchg(id_slider, "2.3");
                                    setTimeout(() => {
                                        // 修改模式
                                        obj_box_gamma_html_child_page.getElementsByClassName("mc_radio_btn")[0].children[2].onmousedown();
                                        setTimeout(() => {
                                            // 点击应用
                                            obj_box_gamma_html_child_page.getElementsByClassName("icon-btn-apply")[0].onclick();
                                            mc_box_gamma_get_child_page(0, "layui-layer-dialog");
                                            setTimeout(() => {
                                                obj_box_gamma_html_child_page.getElementsByClassName("layui-layer-btn0")[0].click();
                                                setTimeout(() => {
                                                    // 点击gamma
                                                    mc_box_gamma_get_child_page("", "iframe_content_subpage");

                                                    obj_box_gamma_html_child_page.getElementsByClassName("icon-gamma")[0].onclick();
                                                    setTimeout(() => {
                                                        mc_box_gamma_get_child_page(0, "layui-layer-iframe");
                                                        mc_box_gamma_get_page_data(function (obj) {
                                                            obj_box_gamma_page_data = obj;

                                                            arr_jungle_result = mc_box_gamma_jungle_param(obj_box_gamma_page_data, obj_box_gamma_jungle_data);

                                                            if (!arr_jungle_result[0]) {
                                                                callback("0", arr_jungle_result[1]);
                                                            } else {
                                                                callback("1", "测试完成,数据显示正确");
                                                            }
                                                            return;
                                                        });
                                                    }, box_gamma_time);
                                                }, box_gamma_time);
                                                return;
                                            }, box_gamma_time);
                                        }, box_gamma_time);
                                    }, box_gamma_time);
                                }, box_gamma_time);
                            }, box_gamma_time);
                        }, box_gamma_time);
                    }, box_gamma_time);
                });
            }, box_gamma_time);
        });
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试界面切换tab栏界面显示 ( SM16159S进行测试 )
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-22
 *       内容 : 所有代码
************************************************************************************************/
function tc_tab_box_gamma(callback) {
    mc_box_gamma_clear_iframe_page();
    mc_box_gamma_test_box_exist(function () {
        mc_box_gamma_open_side_page("mc_side_btn_mod_wizard", function () {
            $(obj_box_gamma_iframe_sub_main).contents().find("#mc_side_btn_add").click();
            setTimeout(() => {
                mc_box_gamma_get_child_page("", "iframe_content_subpage");
                // , 1, 10, 2
                mc_box_gamma_set_chip(2, 11, 6, function (b_go) {
                    if (!b_go) {
                        callback("0", "界面打开超时,请等待box_main界面加载后重新执行此用例");
                        return;
                    }
                    mc_box_gamma_remove_page("dialog");
                    mc_box_gamma_get_child_page(0, "layui-layer-iframe");

                    mc_box_gamma_test_tab(0, function (arr_jungle) {
                        if (!arr_jungle[0]) {
                            callback("0", arr_jungle[1]);
                            return;
                        }
                        // callback("1", "测试完成,数据显示正确");

                        mc_box_gamma_test_tab(1, function () {
                            if (!arr_jungle[0]) {
                                callback("0", arr_jungle[1]);
                                return;
                            }
                            // callback("1", "测试完成,数据显示正确");
                            mc_box_gamma_test_tab(2, function () {
                                if (!arr_jungle[0]) {
                                    callback("0", arr_jungle[1]);
                                    return;
                                }
                                // callback("1", "测试完成,数据显示正确");
                                mc_box_gamma_test_tab(3, function () {
                                    if (!arr_jungle[0]) {
                                        callback("0", arr_jungle[1]);
                                        return;
                                    }
                                    callback("1", "测试完成,数据显示正确");
                                    return;
                                });
                            });
                        });
                    });
                });
            }, box_gamma_time);
        });
    });
}

/* -------------------------------------------------------------------测试用例函数----------------------------------------------------------------- */


/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    选中芯片
 * 参数:
 *    @param { Promise<number> } ui_chip_page 删除界面类型
 *    @param { Promise<number> } ui_ul 芯片下拉列表的ul位置
 *    @param { Promise<number> } ui_li 芯片下拉列表的li列表的位置
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-22
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_set_chip(ui_chip_page, ui_ul, ui_li, callback) {
    setTimeout(() => {
    // 修改主控芯片
        obj_box_gamma_html_child_page.getElementsByClassName("select_text")[0].onclick();
        setTimeout(() => {
            obj_box_gamma_html_child_page.getElementsByClassName("select_list")[0].children[0].onclick();
            setTimeout(() => {
                // 点击显示芯片
                obj_box_gamma_html_child_page.getElementsByClassName("select_text")[2].onclick();
                setTimeout(() => {
                    // 切换ICN2053界面
                    obj_box_gamma_html_child_page.getElementsByClassName("sc_search_title")[0].children[ui_chip_page].onclick();
                    setTimeout(() => {
                        // 点击ICN2053
                        obj_box_gamma_html_child_page.getElementsByClassName("sc_cont_list")[ui_ul].children[ui_li].onclick();

                        setTimeout(() => {
                            // 点击应用
                            obj_box_gamma_html_child_page.getElementById("mc_btn_id_apply").onclick();

                            // 获取提示框
                            mc_box_gamma_get_child_page(0, "layui-layer-dialog");
                            setTimeout(() => {
                                obj_box_gamma_html_child_page.getElementsByClassName("layui-layer-btn")[0].children[0].click();
                                setTimeout(() => {
                                    mc_box_gamma_get_child_page("", "iframe_content_subpage");
                                    if (0 === obj_box_gamma_html_child_page.getElementById("item_group_perfor_config").children.length) {
                                        ui_time_into_boxmain += 1000;
                                        callback(false);
                                        return;
                                    }
                                    obj_box_gamma_html_child_page.getElementsByClassName("icon-gamma")[0].onclick();
                                    setTimeout(() => {
                                        callback(true);
                                        return;
                                    }, ui_time_into_boxmain);
                                }, box_gamma_time);
                            }, box_gamma_time);
                        }, box_gamma_time);
                    }, box_gamma_time);
                }, box_gamma_time);
            }, box_gamma_time);
        }, box_gamma_time);
    }, box_gamma_time);
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    清空所有子页面 和弹框
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_clear_iframe_page() {
    obj_box_gamma_iframe_top = document.getElementById("tifrem_led");
    obj_box_gamma_iframe_sub_main = obj_box_gamma_iframe_top.contentDocument.getElementById("iframe_subpage");
    obj_box_gamma_iframe_child_page = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-iframe");

    var ui_iframe_page_cnt = obj_box_gamma_iframe_child_page.length;

    // 提示弹框
    var arr_dialog_html = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog");

    if (0 < arr_dialog_html.length) {
        obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
    for (var idx = 0; idx < ui_iframe_page_cnt; idx++) {
        obj_box_gamma_iframe_child_page[0].remove();
        obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    去掉提示弹窗/子页面弹窗
 * 参数:
 *    @param { Promise<string> } str_type 删除界面类型
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-21
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_remove_page(str_type) {
    // 弹框提示
    if ("dialog" === str_type) {
        obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        var ui_len_dialog = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade").length;

        // 去掉最后一个遮罩
        obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[ui_len_dialog - 1].remove();
    }

    // 子页面 第三层
    if ("subpage" === str_type) {
        obj_box_gamma_iframe_child_page[0].remove();
        obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }

    // 子页面 第二层内 (主要是硬件选择界面)
    if ("hw_page" === str_type) {
        obj_box_gamma_iframe_child_page[1].remove();
        obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[1].remove();
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    打开侧边栏界面
 * 参数:
 *    @param { Promise<string> } str_id 侧边栏按钮id
 *    @param { Promise<function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-21
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_open_side_page(str_id, callback) {
    $(obj_box_gamma_iframe_sub_main).contents().find("#" + str_id).click();
    setTimeout(() => {
        callback();
        return;
    }, box_gamma_time);
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    确认当前子页面
 * 参数:
 *    @param { Promise<string> } idx_page 需打开第几个iframe界面
 *    @param { Promise<string> } str_type 需打开第几个iframe界面
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    iframe_content_subpage 嵌在界面内
 *    layui-layer-iframe 弹出的界面 (主要是硬件选择界面)
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-19
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_get_child_page(idx_page, str_type) {
    if ("layui-layer-iframe" === str_type) {
        obj_box_gamma_iframe_child_page = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName(str_type);
        obj_box_gamma_html_child_page = obj_box_gamma_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentDocument;
        obj_box_gamma_window_child_page = obj_box_gamma_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentWindow;
    }
    if ("iframe_content_subpage" === str_type) {
        obj_box_gamma_iframe_child_page = obj_box_gamma_iframe_sub_main.contentDocument.getElementById(str_type);
        obj_box_gamma_html_child_page = obj_box_gamma_iframe_child_page.contentDocument;
        obj_box_gamma_window_child_page = obj_box_gamma_iframe_child_page.contentWindow;
    }

    if ("layui-layer-dialog" === str_type) {
        obj_box_gamma_iframe_child_page = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName(str_type);
        obj_box_gamma_html_child_page = obj_box_gamma_iframe_child_page[idx_page];
        obj_box_gamma_window_child_page = obj_box_gamma_iframe_child_page[idx_page];
    }

    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    确认当前子页面
 * 参数:
 *    @param { Promise<Array> } page_data 界面数据
 *    @param { Promise<Array> } jungle_data 比较数据
 * 返回:
 *    @return { Promise<Array> } arr_result 比较数据
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-21
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_jungle_tab(page_data, jungle_data) {
    var arr_result = [true, ""];
    var ui_page_length = page_data.length;
    var ui_jungle_length = jungle_data.length;

    if (ui_page_length !== ui_jungle_length) {
        arr_result[0] = false;
        arr_result[1] = "tab栏显示长度不一致";
        return arr_result;
    }

    for (var idx = 0; idx < ui_page_length; idx++) {
        if (page_data[idx] !== jungle_data[idx]) {
            arr_result[0] = false;
            arr_result[1] = "tab栏界面显示不对应";
            return arr_result;
        }
    }

    return arr_result;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    检测当前界面是否创建箱体或模组
 *  * 参数:
 *    @param { Promise<function> } callback 比较数据
 * 返回:
 *    NA
 * 例子:
 *    先删箱体 再删模组
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-22
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_test_box_exist(callback) {
    mc_box_gamma_open_side_page("mc_side_btn_box", function () {
        if (0 !== obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_box")[0].children.length) {
            var ui_box_cnt = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_box")[0].children.length;

            for (var idx = 0; idx < ui_box_cnt; idx++) {
                var arr_each_box_dom = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_box")[0].children[0];

                arr_each_box_dom.getElementsByClassName("icon-delete")[0].onclick();
            }
        }

        mc_box_gamma_open_side_page("mc_side_btn_mod_wizard", function () {
            if (0 !== obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_mod")[0].children.length) {
                var ui_mod_cnt = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_mod")[0].children.length;

                for (var id = 0; id < ui_mod_cnt; id++) {
                    var arr_each_mod_dom = obj_box_gamma_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_mod")[0].children[0];

                    arr_each_mod_dom.getElementsByClassName("icon-delete")[0].onclick();
                }
            }

            callback();
            return;
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取默认数据
 * 参数:
 *    NA
 * 返回:
 *    @return { Promise<object> } obj 比较数据
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-22
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_default_data() {
    var obj = {
        "chart_type_name": "Calculate",
        "appoint_type_name": "D",
        "type": "2",
        "data": "",
        "gray_bit": "9",
        "y_val": "40000",
        "factor": "2.3",
        "mode_val_idx": "2",
        "box_default_max_val": "65535",
        "curr_ctrl_chip": "FPGA",
        "curr_disp_chip": "SM16159S"
    };

    obj.data = "0,128,256,384,512,640,768,896,1024,1152,1280,1408,1536,1664,1792,1920,2048,2176,2304,2432,2560,2688,2816,2944,3072,3200,3328,3456,3584,3712,3840,3968,4096,4224,4352,4480,4608,4736,4864,4992,5120,5248,5376,5504,5632,5760,5888,6016,6144,6272,6400,6528,6656,6784,6912,7040,7168,7296,7424,7552,7680,7808,7936,8064,8192,8320,8448,8576,8704,8832,8960,9088,9216,9344,9472,9600,9728,9856,9984,10112,10240,10368,10496,10624,10752,10880,11008,11136,11264,11392,11520,11648,11776,11904,12032,12160,12288,12416,12544,12672,12800,12928,13056,13184,13312,13440,13568,13696,13824,13952,14080,14208,14336,14464,14592,14720,14848,14976,15104,15232,15360,15488,15616,15744,15872,16000,16128,16256,16384,16512,16640,16768,16896,17024,17152,17280,17408,17536,17664,17792,17920,18048,18176,18304,18432,18560,18688,18816,18944,19072,19200,19584,19840,20096,20480,20736,21120,21376,21632,22016,22272,22656,22912,23296,23680,23936,24320,24704,24960,25344,25728,25984,26368,26752,27136,27392,27776,28160,28544,28928,29312,29696,30080,30464,30848,31232,31616,32000,32384,32768,33152,33536,34048,34432,34816,35200,35584,36096,36480,36864,37376,37760,38272,38656,39040,39552,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936,39936";
    return obj;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取界面数据
 * 参数:
 *    @param { Promise<function> } callback 回调函数
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-22
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_get_page_data(callback) {
    obj_page = {
        "chart_type_name": "",
        "appoint_type_name": "",
        "type": "",
        "data": "",
        "gray_bit": "",
        "y_val": "",
        "factor": "",
        "mode_val_idx": "",
        "box_default_max_val": "65535",
        "curr_ctrl_chip": "FPGA",
        "curr_disp_chip": "SM16159S"
    };

    // tab栏指定
    obj_page.chart_type_name = obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].getAttribute("default_idx");

    switch (obj_page.chart_type_name) {
    case "0":
        obj_page.chart_type_name = "Defalut";
        break;
    case "1":
        obj_page.chart_type_name = "Appoint";
        break;
    case "2":
        obj_page.chart_type_name = "Calculate";
        break;
    case "3":
        obj_page.chart_type_name = "Customization";
        break;

    default:
        break;
    }


    // 灰阶
    obj_page.gray_bit = obj_box_gamma_html_child_page.getElementsByClassName("select_txt")[0].innerText;

    // y区间max_val
    obj_page.y_val = obj_box_gamma_html_child_page.getElementsByClassName("mc_y_axis_area_second_value")[0].value;
    // gamma值
    obj_page.factor = Number(obj_box_gamma_html_child_page.getElementsByClassName("mc_slider_thumb")[0].innerText).toFixed(1);
    // 模式
    obj_page.mode_val_idx = Number(obj_box_gamma_html_child_page.getElementsByClassName("mc_checkbox_property_btn")[0].children[0].getAttribute("select_index")) - 1;
    obj_page.mode_val_idx = obj_page.mode_val_idx.toString();

    // 表格数据
    var arr_ul = obj_box_gamma_html_child_page.getElementsByClassName("table_row");
    var ui_length = arr_ul.length;
    var arr_data = Array(ui_length);

    for (var idx = 0; idx < ui_length; idx++) {
        arr_data[idx] = obj_box_gamma_html_child_page.getElementsByClassName("table_row")[idx].children[1].innerText;
    }

    obj_page.data = arr_data.toString();

    setTimeout(() => {
    // 跳转到指定表
        obj_page.type = obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].getAttribute("default_idx");
        obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].children[1].onclick();
        // 指定表值
        setTimeout(() => {
            var arr_appoint_html = obj_box_gamma_html_child_page.getElementsByClassName("mc_appoint_gamma_tbl")[0].children[0].children;
            var ui_appoint_length = arr_appoint_html.length;

            for (var id = 0; id < ui_appoint_length; id++) {
                if ("true" === arr_appoint_html[id].getAttribute("radio_select")) {
                    obj_page.appoint_type_name = arr_appoint_html[id].innerText;
                }
            }

            callback(obj_page);
            return;
        }, box_gamma_time);
    }, box_gamma_time);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    比较界面参数
 * 参数:
 *    @param { Promise<object> } page_param 界面参数数据
 *    @param { Promise<object> } jungle_param 比较参数数据
 * 返回:
  *    @return { Promise<Array> } arr_result 比较结果
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-24
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_jungle_param(page_param, jungle_param) {
    var arr_result = [true, ""];

    for (var key in page_param) {
        if (page_param.hasOwnProperty(key)) {
            if (page_param[key] !== jungle_param[key]) {
                arr_result[0] = false;
                arr_result[1] = "参数不一致,参数为" + key;
                break;
            }
        }
    }


    return arr_result;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    比较界面参数
 * 参数:
 *    @param { Promise<number> } ui_tab 界面参数数据
 *    @param { Promise<function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-24
 *       内容 : 所有代码
************************************************************************************************/
function mc_box_gamma_test_tab(ui_tab, callback) {
    // 点击某项
    obj_box_gamma_html_child_page.getElementsByClassName("mc_tab")[0].children[ui_tab].onclick();

    setTimeout(() => {
        var arr_return = [true, ""];

        // 箱体默认表
        if (0 === ui_tab) {
            if ("none" === obj_box_gamma_html_child_page.getElementsByClassName("mc_box_gamma_max ")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "箱体默认表显示界面有误,最大值显示有误";
            }

            if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_appoint_gamma_tbl")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "箱体默认表显示界面有误,指定表控件显示有误";
            }

            if (mc_check_calculator_show()) {
                arr_return[0] = false;
                arr_return[1] = "计算表控件显示有误";
            }
        }
        if (1 === ui_tab) {
            if ("none" === obj_box_gamma_html_child_page.getElementsByClassName("mc_appoint_gamma_tbl")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "指定表控件显示有误";
            }

            if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_box_gamma_max ")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "箱体默认表显示界面有误,最大值显示有误";
            }
            if (mc_check_calculator_show()) {
                arr_return[0] = false;
                arr_return[1] = "计算表控件显示有误";
            }
        }
        if (2 === ui_tab) {
            if (!mc_check_calculator_show()) {
                arr_return[0] = false;
                arr_return[1] = "计算表控件显示有误";
            }

            if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_appoint_gamma_tbl")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "指定表控件显示有误";
            }

            if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_box_gamma_max ")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "箱体默认表显示界面有误,最大值显示有误";
            }
        }
        if (3 === ui_tab) {
            if (mc_check_calculator_show()) {
                arr_return[0] = false;
                arr_return[1] = "计算表控件显示有误";
            }

            if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_appoint_gamma_tbl")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "指定表控件显示有误";
            }

            if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_box_gamma_max ")[0].style.display) {
                arr_return[0] = false;
                arr_return[1] = "箱体默认表最大值显示有误";
            }
        }

        callback(arr_return);
        return;
    }, box_gamma_time);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断当前计算表界面是否打开
 * 参数:
 *    NA
 * 返回:
 *    @return { Promise<function> } b_show false未显示 / true显示
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-24
 *       内容 : 所有代码
************************************************************************************************/
function mc_check_calculator_show() {
    var b_show = false;

    if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_radio_checkbox")[0].style.display) {
        b_show = true;
    }
    if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_straight_scroll")[0].style.display) {
        b_show = true;
    }
    if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_y_axis_area")[0].style.display) {
        b_show = true;
    }
    if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_x_axis_area")[0].style.display) {
        b_show = true;
    }
    if ("none" !== obj_box_gamma_html_child_page.getElementsByClassName("mc_gray_scale")[0].style.display) {
        b_show = true;
    }

    return b_show;
}

/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */
